CREATE TABLE [ia_gassales](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[pcc] [varchar](6) NULL,
	[registry_type] [varchar](2) NULL,
	[date_gassale] [varchar](14) NULL,
	[num_receipt] [varchar](10) NULL,
	[surt_face] [varchar](1) NULL,
	[surt_hose] [varchar](1) NULL,
	[productref_code] [varchar](2) NULL,
	[ppu] [varchar](6) NULL,
	[volume] [varchar](7) NULL,
	[total] [varchar](9) NULL,
	[id_code] [varchar](16) NULL,
	[plate] [varchar](8) NULL,
	[odometer] [varchar](8) NULL,
	[id_employee] [varchar](16) NULL,
	[tax] [varchar](3) NULL,
	[consec] [int] NULL,
	[bill_prefix] [varchar](10) NULL,
	[md5] [varchar](32) NULL,
	[csv_data] [varchar](300) NULL,
	[date_short] [varchar](8) NULL,
	[time_short] [varchar](6) NULL,
	[has_errors] [varchar](1) NULL,
	[num_bill] [varchar](8) NULL,
	[payment_type] [varchar](2) NULL,
	[is_pending] [varchar](1) NULL,
 CONSTRAINT [PK_gassales] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [uidx_gassales] ON [ia_gassales] 
(
	[date_gassale] ASC,
	[pcc] ASC,
	[num_receipt] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY];

CREATE TABLE [ia_gasclosehoses](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[pcc] [varchar](6) NULL,
	[registry_type] [varchar](2) NULL,
	[date_ini] [varchar](14) NULL,
	[date_end] [varchar](14) NULL,
	[surt_face] [varchar](1) NULL,
	[surt_hose] [varchar](1) NULL,
	[produtref_code] [varchar](2) NULL,
	[money_start] [varchar](10) NULL,
	[money_end] [varchar](10) NULL,
	[volume_start] [varchar](10) NULL,
	[volume_end] [varchar](10) NULL,
	[consec] [int] NULL,
	[id_employee] [varchar](16) NULL,
	[ppu] [varchar](10) NULL,
	[last] [varchar](1) NULL,
	[bill_prefix] [varchar](3) NULL,
	[gasclose_id] [int] NULL,
    CONSTRAINT [PK_gasclosehoses] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [uidx_gassales] ON [ia_gassales] 
(
	[date_gassale] ASC,
	[pcc] ASC,
	[num_receipt] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY];

CREATE TABLE [ia_gascloses](
	[id] [int] IDENTITY(1,1) NOT NULL,
    [registry_type] [varchar](2) NULL,
	[pcc] [varchar](6) NULL,
	[date_start] [varchar](14) NULL,
	[date_end] [varchar](14) NULL,
	[consec] [int] NULL,
	[id_employee] [varchar](16) NULL,
	[num_hoses] [int] NULL,
    CONSTRAINT [PK_gascloses] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [uidx_ia_gascloses] ON [ia_gascloses] 
(
	[pcc] ASC,
	[date_start] ASC,
	[date_end] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY];


CREATE TABLE [ia_vehicles](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[first_name] [varchar](50) NULL,
	[last_name] [varchar](50) NULL,
	[id_code] [varchar](16) NULL,
	[doc] [varchar](15) NULL,
	[plate] [varchar](8) NULL,
	[vehicle_code] [varchar](10) NULL,
    [phone1] [varchar](12) NULL,
 CONSTRAINT [PK_ia_vehicles] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [uidx_ia_vehicles_code] ON [ia_vehicles] 
(
	[id_code] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY];

CREATE UNIQUE NONCLUSTERED INDEX [uidx_ia_vehicles_plate] ON [ia_vehicles] 
(
	[plate] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY];

