<?php
/*
  Workflows Invoke Custom Function example Register file (myExample_REGISTER.php)

  This will register a specific method function created in the myExample.inc 
  This method function can then be invoked under: 
   Workflows > New Condition > New Task > Invoke Custom Function

  HOW TO REGISTER FUNCTION:
  In order to register the function, this Register file needs to be placed in
   your vTiger root directory, and then you manually need to call it from your
   browser: http://www.mydomain.com/vtiger/myExample_REGISTER.php

  WARNING: You only want to call this register file ONCE...
   Everytime you call this register file, it will add the function to the
   vtiger_workflowtasks_entitymethod table in the database, so if you call it
   more than once then it will get added to the database more than once.
   
  To REMOVE a registered method function, you need to manually delete it from the
   vtiger_workflowtasks_entitymethod table in the database.

  $emm->addEntityMethod("ModuleName", "MyMethodName", "modules/Workflow/myExample.inc", "myExampleFunctionName");
    ModuleName - Valid module names are: Contacts, PurchaseOrder, ???more???
    MyMethodName - This is the name that will appear in the drop down list for you to choose from.
    modules/Workflow/myExample.inc - The path and filename that contains the method function. 
     If the modules/Workflow/ directory does not exist, then just create it!
    myMethodFunctionName - The name of the method function declared in myExample.inc
*/

require_once 'include/utils/utils.php';
require 'modules/com_vtiger_workflow/VTEntityMethodManager.inc';
$emm = new VTEntityMethodManager($adb);
$emm->addEntityMethod("Contacts", "iaExample Send Me an Email", "modules/Workflow/iaExample.inc", "iaExample");
echo 'addEntityMethod complete!';
?>
